<?xml version="1.0" encoding="iso-8859-1"?>
<!--
  Copyright 1999-2004 The Apache Software Foundation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->

<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cinclude="http://apache.org/cocoon/include/1.0"
  xmlns:xi="http://www.w3.org/2001/XInclude"
  xmlns:lucene="http://apache.org/cocoon/lucene/1.0" 
>
<xsl:param name="create" select="'false'"/>
  <xsl:template match="includes">
    <lucene:index 
      analyzer="org.apache.lucene.analysis.standard.StandardAnalyzer" 
      directory="injac-index" 
      create="{$create}" 
      merge-factor="10">

      <xsl:apply-templates/>

    </lucene:index>
  </xsl:template>

  <xsl:template match="file">
  <!-- important : file doit tre le dernier paramtre pass dans l'uri (search-index2html.xsl en dpends)-->
    <lucene:document url="{href}?title={title}&amp;file={name}">
      <title lucene:store="true"><xsl:value-of select="title"/></title>  
      <xsl:copy-of select="include/*"/>
    </lucene:document>
  </xsl:template>

  <xsl:template match="@*|node()" priority="-1"></xsl:template>
  <xsl:template match="text()" priority="-1"></xsl:template>
</xsl:stylesheet> 